package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.UserProfileDeactivationAudit;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserProfileDeactivationAuditRepository extends JpaRepository<UserProfileDeactivationAudit, Long> {

	@Query("select u from UserProfileDeactivationAudit u where u.userProfile.id = :userProfileId order by u.changeDate DESC")
	public List<UserProfileDeactivationAudit> findUserProfileDeactivationAuditByUser(
			@Param("userProfileId") Long userProfileId);
}
